// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import Foundation

enum HTTPUtils {
    private static let session: URLSession = {
        let sessionConfiguration = URLSessionConfiguration.default
        
        // Needed to wait for Local Network permission popup
        sessionConfiguration.waitsForConnectivity = true
        sessionConfiguration.timeoutIntervalForResource = 60
        
        return URLSession(configuration: sessionConfiguration)
    }()

    static func performJsonRequestOnServerUrl(serverURL: String, content: [String: Any], debug: Bool, completionHandler: @escaping (_ command: String?) -> Void) {
        let url = URL(string: serverURL)
        guard let realUrl = url else {
            assertionFailure("Failed to convert serverUrl to URL type")
            return
        }
        var request = URLRequest(url: realUrl)
        request.httpMethod = "POST"
        request.setValue("Application/json", forHTTPHeaderField: "Content-Type")
        guard let httpBody = try? JSONSerialization.data(withJSONObject: content, options: []) else {
            return
        }
        request.httpBody = httpBody
        
        let session = HTTPUtils.session
        
        session.dataTask(with: request) { data, response, error in
            var bSuccess = false
            if let httpResponse = response as? HTTPURLResponse,
               let data = data,
               httpResponse.statusCode == 200 {
                do {
                    let json = try JSONSerialization.jsonObject(with: data, options: []) as? [String: Any]
                    print(json ?? "Empty json")
                    let command = json?[ConfigurableConstants.serverCommandKey] as? String
                    bSuccess = true
                    DispatchQueue.main.async {
                        completionHandler(command)
                    }
                } catch {
                    print(error)
                }
            }
            if !bSuccess {
                DispatchQueue.main.async {
                    completionHandler(nil)
                }
            }
        }
        .resume()
    }
}
